from django import forms

from webapp.models import Countries, Docbranche

types = (
    ('doctor', 'Doctor'), ('hospital', 'Hospital'), ('lab', 'Laboratory'),
    ('ray', 'Radiology Center'), ('pharmacy', 'Pharmacy'),)

special_list = (
    ('1', 'الجراحة الــعامـة'), ('2', 'جراحة الاوعية الدموية'), ('3', 'جراحة الاطفـال'), ('4', 'جراحة القلب والصدر'),
    ('5', 'جراحة التجميل والحـــروق'), ('6', 'العظام'), ('7', 'جراحة المسالك البولية والكـلي'),
    ('8', 'الباطنة العامـة'), ('9', 'باطنة كلي'), ('10', 'باطنة قلب وأوعية دموية'),
    ('11', 'باطنة حميات وجهاز هضمي وكبد'),
    ('12', 'الامراض الصدريــة'), ('13', 'أنف وأذن وحنجرة'), ('14', 'عيون / رمد'), ('15', 'جلدية وأمراض تناسلية'),
    ('16', 'روماتيزم ومناعة'), ('17', 'غدد صماء'), ('18', 'الأورام والطب النووي'), ('19', 'علاج الالام'),
    ('20', 'جراحة المخ والأعصاب'), ('21', 'مخ واعصاب وطب نفسي'), ('22', 'النساء والتوليد'), ('23', 'الأطفال'),
    ('24', 'تغذية علاجية'), ('25', 'طب وجراحة الأسنان'), ('26', 'العلاج الطبيعي'), ('27', 'امراض دم'))


class AddForm(forms.Form):
    choose_type = forms.ChoiceField(choices=types)
    name = forms.CharField(required=True)
    special = forms.ChoiceField(required=False, choices=special_list)
    country = forms.ModelChoiceField(queryset=Countries.objects.all(), empty_label="Selected value")
    address = forms.CharField(required=True)
    notes = forms.CharField(required=False,
                            widget=forms.Textarea(attrs={'placeholder': 'You can place your Notes here', 'rows': "4"}))
    number = forms.CharField(required=False,
                             widget=forms.Textarea(
                                 attrs={
                                     'placeholder': 'You can Add multiple Numbers Should be Quma Separated eg : 4010410410,14014140',
                                     'rows': "3"}))


class SearchForm(forms.Form):
    choose_type = forms.ChoiceField(choices=types)


class ExtraDiv(forms.Form):
    country = forms.ModelChoiceField(queryset=Countries.objects.all(), empty_label="Selected value")
    address = forms.CharField(required=True)
    number = forms.CharField(widget=forms.NumberInput(attrs={'placeholder': 'Number'}))
