<?php
// افترض أن لديك ملف config.php يحتوي على معلومات الاتصال بقاعدة البيانات
require_once "../connection.php" ;

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// تأكد من أن الطلب هو POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $inputJSON = file_get_contents('php://input');
    $input = json_decode($inputJSON, true); // تحويل JSON إلى مصفوفة
    
    // جمع البيانات من طلب POST
    $name = $_POST['name'];
    $special = $_POST['special'];
    $specialname = $_POST['specialname'];
    $note = $_POST['note'];
    // يجب أن تكون $addresses و $numbers مصفوفات JSON مرسلة من Flutter
    $addresses = json_decode($_POST['addresses']);
    $numbers = json_decode($_POST['numbers']);
    $country = $_POST['country']; // افترض أن هذا مرسل أيضاً

    // الاتصال بقاعدة البيانات
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

    // التحقق من الاتصال
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // تأمين البيانات قبل إدخالها في قاعدة البيانات
    $name = mysqli_real_escape_string($conn, $input['name']);
    $special = mysqli_real_escape_string($conn, $input['special']);
    $specialname = mysqli_real_escape_string($conn, $input['specialname']);
    $note = mysqli_real_escape_string($conn, $input['note']);
    $addresses = mysqli_real_escape_string($conn, $input['addresses']);
    //$numbers = mysqli_real_escape_string($conn, $input['numbers']);
    $country = mysqli_real_escape_string($conn, $input['country']);

    // بدء المعاملة
    $conn->begin_transaction();

    try {
        // إدخال البيانات في الجدول الرئيسي
        $stmt = $conn->prepare("INSERT INTO webapp_doctors (name, special, specialname, note) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $name, $special, $specialname, $note);
        $stmt->execute();
        $webapp_doctor_id = $stmt->insert_id; // الحصول على id للدكتور المضاف

        // إدخال العناوين
        foreach ($addresses as $address) {
            $stmt = $conn->prepare("INSERT INTO webapp_docbranche (branche) VALUES (?)");
            $stmt->bind_param("s", $address);
            $stmt->execute();
            $address_id = $stmt->insert_id; // الحصول على id للعنوان المضاف

            // إدخال رابط العنوان بالدكتور
            $stmt = $conn->prepare("INSERT INTO webapp_docrelation (relation_name, relation_country, relation_branche) VALUES (?, ?, ?)");
            $stmt->bind_param("isi", $webapp_doctor_id, $country, $address_id);
            $stmt->execute();
        }

        // إدخال الأرقام وربطها بالعناوين
        foreach ($numbers as $number) {
            $stmt = $conn->prepare("INSERT INTO webapp_docnumber (number) VALUES (?)");
            $stmt->bind_param("s", $number->number);
            $stmt->execute();
            $number_id = $stmt->insert_id; // الحصول على id للرقم المضاف

            // لكل رقم، قم بربطه بعنوان
            foreach ($number->addresses as $address_id) {
                $stmt = $conn->prepare("INSERT INTO webapp_docbranchrel (relation_number, relation_branche) VALUES (?, ?)");
                $stmt->bind_param("ii", $number_id, $address_id);
                $stmt->execute();
            }
        }

        // إذا كل شيء على ما يرام، ارتكب المعاملة
        $conn->commit();
        echo "New records created successfully";
    } catch (Exception $e) {
        // هناك خطأ، قم بالتراجع عن كل شيء
        $conn->rollback();
        echo "Error: " . $e->getMessage();
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>
