from django.contrib.auth.decorators import login_required
from django.contrib.auth.views import LoginView, LogoutView
from django.urls import path
from webapp import views

urlpatterns = [
    path('', login_required(views.home.as_view()), name='home'),
    path('search_results/', login_required(views.search_results.as_view()), name='search_results'),
    path('search_results/del/<int:id>/<str:choice_type>/', login_required(views.del_search_results),
         name='del_search_results'),
    path('login', LoginView.as_view(template_name='webapp/login_page.html', success_url='home'), name='login'),
    path('logout', LogoutView.as_view(), name='logout'),
    path('search_results/update/<int:id>/<str:choice>/', login_required(views.update_search_results.as_view()),
         name='update_search_results'),
    path('search_results/update_data/', login_required(views.update_data.as_view()),
         name='update_data'),

]
