from django.http import HttpResponse, JsonResponse
from django.shortcuts import render, get_object_or_404

# Create your views here.
from django.template.loader import render_to_string
from django.views import View
from django.views.generic import UpdateView, TemplateView

from webapp.forms import AddForm, SearchForm, ExtraDiv
from webapp.models import Doctors, Docnumber, Docbrancherel, Docbranche, Docrelation, Countries, Labs, Labnumber, \
    Labbranche, Labbrancherel, Labrelation, Hospitals, Hosrelation, Hosnumber, Hosbrancherel, Hosbranche, Phabranche, \
    Phabrancherel, Phanumber, Pharelation, Pharmacies, Rays, Rayrelation, Raynumber, Raybrancherel, Raybranche

special_data = {'1': 'الجراحة الــعامـة', '2': 'جراحة الاوعية الدموية', '3': 'جراحة الاطفـال',
                '4': 'جراحة القلب والصدر', '5': 'جراحة التجميل والحـــروق', '6': 'العظام',
                '7': 'جراحة المسالك البولية والكـلي', '8': 'الباطنة العامـة', '9': 'باطنة كلي',
                '10': 'باطنة قلب وأوعية دموية', '11': 'باطنة حميات وجهاز هضمي وكبد', '12': 'الامراض الصدريــة',
                '13': 'أنف وأذن وحنجرة', '14': 'عيون / رمد', '15': 'جلدية وأمراض تناسلية', '16': 'روماتيزم ومناعة',
                '17': 'غدد صماء', '18': 'الأورام والطب النووي', '19': 'علاج الالام', '20': 'جراحة المخ والأعصاب',
                '21': 'مخ واعصاب وطب نفسي', '22': 'النساء والتوليد', '23': 'الأطفال', '24': 'تغذية علاجية',
                '25': 'طب وجراحة الأسنان', '26': 'العلاج الطبيعي'}


def get_tables_set(choice):
    if choice == 'doctor':
        choice = {
            'main': Doctors,
            'relation': Docrelation,
            'number': Docnumber,
            'brancherel': Docbrancherel,
            'branche': Docbranche,
        }
    elif choice == 'lab':
        choice = {
            'main': Labs,
            'relation': Labrelation,
            'number': Labnumber,
            'brancherel': Labbrancherel,
            'branche': Labbranche,
        }
    elif choice == 'hospital':
        choice = {
            'main': Hospitals,
            'relation': Hosrelation,
            'number': Hosnumber,
            'brancherel': Hosbrancherel,
            'branche': Hosbranche,
        }
    elif choice == 'pharmacy':
        choice = {
            'main': Pharmacies,
            'relation': Pharelation,
            'number': Phanumber,
            'brancherel': Phabrancherel,
            'branche': Phabranche,
        }
    elif choice == 'ray':
        choice = {
            'main': Rays,
            'relation': Rayrelation,
            'number': Raynumber,
            'brancherel': Raybrancherel,
            'branche': Raybranche,
        }

    return choice


def add_info(request, choice):
    try:
        include_special_fields = False
        if choice == 'doctor':
            include_special_fields = True
        choice = get_tables_set(choice)
        main_table = choice['main']()
        main_table.name = request.POST.get('name', False)
        if include_special_fields:
            main_table.special = request.POST.get('special', False)
            main_table.specialname = special_data.get(main_table.special, '')
        main_table.note = request.POST.get('notes', False)
        main_table.save()

        numbers_dict = {}
        temp_number_list = []
        set_of_numbers = request.POST.get('number', False)
        multiple_numbers = set_of_numbers.split(',')
        for number_info in multiple_numbers:
            if number_info:
                number = choice['number']()
                number.number = number_info
                number.save()
                temp_number_list.append(number)
        numbers_dict[0] = temp_number_list
        dict_key_count = 1
        for i in range(1, 6):
            temp_number_list = []
            number_to_save = request.POST.get(f'number{i}', False)
            if number_to_save:
                multiple_numbers = number_to_save.split(',')
                for number_info in multiple_numbers:
                    if number_info:
                        number = choice['number']()
                        number.number = number_info
                        number.save()
                        temp_number_list.append(number)
                numbers_dict[dict_key_count] = temp_number_list
                dict_key_count += 1

        branches = []
        branche = choice['branche']()
        branche.branche = request.POST.get('address', False)
        branche.save()
        branches.append(branche)
        for i in range(1, 6):
            branche_to_save = request.POST.get(f'address{i}', False)
            if branche_to_save:
                branche = choice['branche']()
                branche.branche = branche_to_save
                branche.save()
                branches.append(branche)

        countries = []
        country_id = request.POST.get('country', False)
        country = Countries.objects.get(id=country_id)
        countries.append(country)
        for i in range(1, 6):
            country_id = request.POST.get(f'country{i}', False)
            if country_id:
                country = Countries.objects.get(id=country_id)
                countries.append(country)
        for count, branche in enumerate(branches):
            relation = choice['relation']()
            relation.relation_name = main_table
            relation.relation_branche = branche
            relation.relation_country = countries[count]
            relation.save()
            if numbers_dict[count]:
                for numbers_info in numbers_dict[count]:
                    docbrancherel = choice['brancherel']()
                    docbrancherel.relation_number = numbers_info
                    docbrancherel.relation_branche = branche
                    docbrancherel.save()
        return "Record Saved Successfully"


    except Exception as e:
        print(e)
        return e


class home(View):

    def get(self, request):
        countries = Countries.objects.all()
        return render(request, 'webapp/home.html', context={"form": AddForm, 'countries': countries})

    def post(self, request):
        countries = Countries.objects.all()
        choose_type = request.POST.get('choose_type', False)
        response = add_info(request, choose_type)
        return render(request, 'webapp/home.html', context={"form": AddForm, 'response': response, 'countries': countries})


def get_info(choice, many=None, id=None):
    include_special_fields = False
    if choice == 'doctor':
        include_special_fields = True
    choice = get_tables_set(choice)
    response = []
    if many:
        doctors = choice['main'].objects.filter(id=id)
    else:
        doctors = choice['main'].objects.all()
    for doctor in doctors:
        data = {'name': doctor.name,
                'id': doctor.id}
        if include_special_fields:
            data['special'] = doctor.special
            data['specialname'] = doctor.specialname
        data['note'] = doctor.note
        docrelations = choice['relation'].objects.filter(relation_name=doctor)
        contact_info = []
        branches = []
        countries = []
        for docrelation in docrelations:

            data_to_append_brannch = {
                'value': docrelation.relation_branche.branche,
                'country': docrelation.relation_country.name,
                'id': docrelation.relation_country.id,
            }
            if data_to_append_brannch not in branches:
                branches.append(data_to_append_brannch)

            numbers = []

            docbrancherel = choice['brancherel'].objects.filter(relation_branche=docrelation.relation_branche.id)

            for brancherel_data in docbrancherel:

                data_to_append = {
                    'id': brancherel_data.relation_number.id,
                    'value': brancherel_data.relation_number.number
                }
                if data_to_append not in numbers:
                    numbers.append(data_to_append)
                data_to_append_brannch['numbers'] = numbers
            data_to_save = {

                'data': branches
            }
            data['extra_info'] = data_to_save
        response.append(data)

    return response


class search_results(View):

    def get(self, request):
        choose_type = request.POST.get('choose_type', False)

        return render(request, 'webapp/show_data.html', context={'form': SearchForm, })

    def post(self, request):
        choose_type = request.POST.get('choose_type', False)

        results = get_info(choose_type)

        return render(request, 'webapp/show_data.html',
                      context={'form': SearchForm, 'results': results, 'type': choose_type, })


def del_search_results(request, id, choice_type):
    choice = get_tables_set(choice_type)
    try:
        doctors = choice['main'].objects.filter(id=id)
        for doctor in doctors:
            docrelations = choice['relation'].objects.filter(relation_name=doctor)
            for docrelation in docrelations:
                docbrancherel = choice['brancherel'].objects.filter(relation_branche=docrelation.relation_branche.id)
                for brancherel_data in docbrancherel:
                    number = choice['number'].objects.get(id=brancherel_data.relation_number.id)

                    number.delete()

                branch = choice['branche'].objects.get(id=docrelation.relation_branche.id)

                branch.delete()
            doctor.delete()
        msg = 'Deleted Successfully'
    except Exception as e:
        msg = e

    results = get_info(choice)

    return render(request, 'webapp/show_data.html',
                  context={'form': SearchForm, 'results': results, 'type': choice_type, 'msg': msg})


class update_search_results(View):
    def get(self, request, id, choice):
        data = get_info(choice, many=True, id=id)
        data = data[0] if data[0] else ''
        countries = Countries.objects.all()
        return render(request, 'webapp/update_record.html',
                      context={'data': data, "form": AddForm, 'type': choice, 'countries': countries})


class update_data(View):
    def post(self, request):

        choose_type = request.POST.get('choose_type', False)
        main_id = request.POST.get('main_id', False)
        choice = get_tables_set(choose_type)

        doctors = choice['main'].objects.filter(id=main_id)
        for doctor in doctors:
            docrelations = choice['relation'].objects.filter(relation_name=doctor)
            for docrelation in docrelations:
                docbrancherel = choice['brancherel'].objects.filter(relation_branche=docrelation.relation_branche.id)
                for brancherel_data in docbrancherel:
                    number = choice['number'].objects.get(id=brancherel_data.relation_number.id)

                    number.delete()

                branch = choice['branche'].objects.get(id=docrelation.relation_branche.id)

                branch.delete()

            doctor.delete()

        add_info(request, choose_type)
        results = get_info(choose_type)
        return render(request, 'webapp/show_data.html',
                      context={'form': SearchForm, 'results': results, 'type': choose_type, })
